<?php
function alderwood_roster_administration()
{
    $administrations = get_users(array('role__in' => array('administrator')));
    ?>
    <div class="datatables_modal hidden">
        <h2>Enter the administrator information below</h2>
        <form name="modal_administration_form" id="modal_administration_form">
            <label>First Name</label>
            <input type="text" name="first_name" required>
            <label>Last Name</label>
            <input type="text" name="last_name" required>
            <label>Email</label>
            <input type="email" name="email" required>
            <label>Phone Number</label>
            <input type="tel" name="phone" required>
            <label>Title</label>
            <input type="text" name="title" required>

            <button type="button" id="add_administration">Add</button>
            <button type="button" id="cancel_administration">Close</button>
        </form>
    </div>
    <div class="datatables_header">
        <button type="button" id="administration_modal" class="datatable_header_button_add">Add Administration</button>
        <button type="button" id="delete_administration" class="datatable_header_button_delete">Delete</button>
    </div>
    <div class="datatables_wrapper">
        <?php
        if (count($administrations) > 1) { ?>
            <table id="administration" class="display" style="width:100%">
                <thead>
                <tr>
                    <th>First Name</th>
                    <th>Last Name</th>
                    <th>Email</th>
                    <th>Phone Number</th>
                    <th>Title</th>
                    <th>Created On</th>
                    <th>Actions</th>
                </tr>
                </thead>
                <tbody>
                <?php
                foreach ($administrations as $administration) {
                    if($administration->ID !== 1){
                    $user = new WP_User($administration->ID);
                    $first_name = $user->first_name;
                    $last_name = $user->last_name;
                    $phone_number = $user->phone_number;
                    $team = $user->title;
                    ?>
                    <tr>
                        <td><?= $first_name ?></td>
                        <td><?= $last_name ?></td>
                        <td><?= $administration->user_email ?></td>
                        <td><?= $phone_number ?></td>
                        <td><?= $team ?></td>
                        <td><?= $administration->user_registered ?></td>
                        <td id="<?= $administration->ID ?>">
                            <input type="checkbox" name="delete_select" class="delete_select" value="delete">
                            <label>Delete</label>
                        </td>
                    </tr>
                    <?php
                    }
                } ?>
                </tbody>
                <tfoot>
                <tr>
                    <th>First Name</th>
                    <th>Last Name</th>
                    <th>Email</th>
                    <th>Phone Number</th>
                    <th>Title</th>
                    <th>Created On</th>
                    <th>Actions</th>
                </tr>
                </tfoot>
            </table>
            <?php
        } else {
            echo '<p>No administrators have been added yet.</p>';
        }
        ?>
    </div>
    <?php
}

add_action("wp_ajax_create_administration", "create_administration");
function create_administration()
{
    $pairs = explode('&', $_POST['data']);
    $data = [];
    foreach ($pairs as $pair) {
        list($key, $value) = explode('=', $pair);
        $data[urldecode($key)] = urldecode($value);
    }
    $userdata = [
        'user_email' => $data['email'],
        'user_login' => $data['first_name'] . '_' . $data['last_name'],
        'first_name' => $data['first_name'],
        'last_name' => $data['last_name'],
        'role' => 'administrator',
    ];
    $userid = wp_insert_user($userdata);
    if (!is_wp_error($userid)) {
        add_user_meta($userid, 'phone_number', $data['phone']);
        add_user_meta($userid, 'title', $data['title']);
    } else {
        /* Error Handling */
        var_dump($userid);
    }
    wp_send_json_success();
}

add_action("wp_ajax_delete_administration", "delete_administration");
function delete_administration()
{
    foreach ($_POST['data'] as $admin) {
        wp_delete_user($admin);
    }
    wp_send_json_success();
}