<?php
/*
 * Plugin Name:       Alderwood Core
 * Plugin URI:        https://alderwoodsoftball.primitiv.media/
 * Description:       This plugin initializes needed functions for the rostering/registering process.
 * Version:           1.0.0
 * Requires at least: 5.2
 * Requires PHP:      7.2
 * Author:            Nicolas Montigny
 * Author URI:        https://primitiv.media/
 * Text Domain:       alderwood-core-plugin
 */
// error_reporting(E_ALL);
// ini_set('display_errors', '1');

include( plugin_dir_path( __FILE__ ) . 'coaches.php');
include( plugin_dir_path( __FILE__ ) . 'administration.php');
include( plugin_dir_path( __FILE__ ) . 'umpires.php');
include( plugin_dir_path( __FILE__ ) . 'teams.php');
include( plugin_dir_path( __FILE__ ) . 'players.php');
include( plugin_dir_path( __FILE__ ) . 'divisions.php');
include( plugin_dir_path( __FILE__ ) . 'teams-view.php');

/**
 * Add new user roles
 */
add_role('t-ball', 'T-Ball', ['subscriber' => true]);
add_role('rookie', 'Rookie', ['subscriber' => true]);
add_role('mites', 'Mites', ['subscriber' => true]);
add_role('coaches', 'Coaches', ['subscriber' => true]);
add_role('umpires', 'Umpires', ['subscriber' => true]);
add_role('asa-kids', 'Asa Kids', ['subscriber' => true]);
/**
 * Add teams options array
 */
function alderwood_core_register_settings()
{
    register_setting('alderwood_teams', 'teams');
    add_option('notices', ['text' => '', 'background-color' => '', 'text-color' => '', 'hidden' => true]);
}

add_action('admin_init', 'alderwood_core_register_settings');

/**
 * Register the roster menu item
 */
function alderwood_core_roster_menu_item()
{
    add_menu_page(
        __('Roster', 'alderwood-core-plugin'),
        __('Roster', 'alderwood-core-plugin'),
        'manage_options',
        'alderwood-roster',
        'intialize_roster',
        'dashicons-groups',
        6
    );
}

add_action('admin_menu', 'alderwood_core_roster_menu_item');

function intialize_roster()
{
    $buttons = [
        'teams',
        'divisions',
        'players',
        'coaches',
        'umpires',
        'administration',
		'notices'
    ];

    echo '<div id="roster-main">';
    foreach ($buttons as $button) {
        echo '<div class="roster-button"><a href="' . get_admin_url() . 'admin.php?page=alderwood-roster-' . $button . '">' . $button . '</a></div>';
    }
    echo '</div>';
}

/**
 * Add the teams plugin page.
 */
function alderwood_core_roster_teams_page()
{
    add_submenu_page(
        'alderwood-roster',
        __('Teams', 'alderwood-core-plugin'),
        __('Teams', 'alderwood-core-plugin'),
        'manage_options',
        'alderwood-roster-teams',
        'alderwood_roster_teams'
    );
}

add_action('admin_menu', 'alderwood_core_roster_teams_page');

/**
 * Add the players plugin page.
 */
function alderwood_core_roster_players_page()
{
    add_submenu_page(
        'alderwood-roster',
        __('Players', 'alderwood-core-plugin'),
        __('Players', 'alderwood-core-plugin'),
        'manage_options',
        'alderwood-roster-players',
        'alderwood_roster_players'
    );
}

add_action('admin_menu', 'alderwood_core_roster_players_page');
/**
 * Add the coaches plugin page.
 */
function alderwood_core_roster_coaches_page()
{
    add_submenu_page(
        'alderwood-roster',
        __('Coaches', 'alderwood-core-plugin'),
        __('Coaches', 'alderwood-core-plugin'),
        'manage_options',
        'alderwood-roster-coaches',
        'alderwood_roster_coaches'
    );
}

add_action('admin_menu', 'alderwood_core_roster_coaches_page');

/**
 * Add the umpires plugin page.
 */
function alderwood_core_roster_umpires_page()
{
    add_submenu_page(
        'alderwood-roster',
        __('Umpires', 'alderwood-core-plugin'),
        __('Umpires', 'alderwood-core-plugin'),
        'manage_options',
        'alderwood-roster-umpires',
        'alderwood_roster_umpires'
    );
}

add_action('admin_menu', 'alderwood_core_roster_umpires_page');

/**
 * Add the administration plugin page.
 */
function alderwood_core_roster_administration_page()
{
    add_submenu_page(
        'alderwood-roster',
        __('Administration', 'alderwood-core-plugin'),
        __('Administration', 'alderwood-core-plugin'),
        'manage_options',
        'alderwood-roster-administration',
        'alderwood_roster_administration'
    );
}

add_action('admin_menu', 'alderwood_core_roster_administration_page');

/**
 * Add the divisions plugin page.
 */
function alderwood_core_roster_divisions_page()
{
    add_submenu_page(
        'alderwood-roster',
        __('Divisions', 'alderwood-core-plugin'),
        __('Divisions', 'alderwood-core-plugin'),
        'manage_options',
        'alderwood-roster-divisions',
        'alderwood_roster_divisions'
    );
}

add_action('admin_menu', 'alderwood_core_roster_divisions_page');

/**
 * Register and enqueue a custom stylesheet in the WordPress admin.
 */
function alderwood_core_scripts()
{
    wp_enqueue_style('alderwood_core_css', plugin_dir_url(__FILE__) . 'style.css', false, '1.0.26');
    wp_register_script('datatables_initialization', plugin_dir_url(__FILE__) . 'datatables_initialization.js', array(), '1.0.76', true);
    wp_enqueue_script('datatables_initialization');
    wp_localize_script(
        'datatables_initialization',
        'ajax_object',
        array('ajaxurl' => admin_url('admin-ajax.php'))
    );
    wp_enqueue_style('datatables_css', 'https://cdn.datatables.net/2.2.0/css/dataTables.dataTables.min.css', false, '1.0.0');
    wp_enqueue_script('datatables_js', 'https://cdn.datatables.net/2.2.0/js/dataTables.min.js', array(), '1.0.0', true);
}

add_action('admin_enqueue_scripts', 'alderwood_core_scripts');

add_action( 'user_registration_after_register_user_action','user_registration_after_register_user_action');

function user_registration_after_register_user_action ($valid_form_data) {
    if (class_exists(\MailPoet\API\API::class)) {
        // Get MailPoet API instance
        $mailpoet_api = \MailPoet\API\API::MP('v1');
        $user_email = $valid_form_data['user_email']->value;
        $user_first = $valid_form_data['first_name']->value;
        $user_last = $valid_form_data['last_name']->value;
        $division = $valid_form_data['multiple_choice_1737232628']->value;
        $kid2_division = $valid_form_data['multiple_choice_1737232683757']->value;
        $kid3_division = $valid_form_data['multiple_choice_1737232683344']->value;

// var_dump($valid_form_data);
        function getDivisionName($division){
            $division = array_keys($division);
            $division = explode(" ",$division[0]);
            $division = str_replace('["','',$division[0]);
            return $division;
        }

        $division = getDivisionName($division);
        $kid2_division = getDivisionName($kid2_division);
        $kid3_division = getDivisionName($kid3_division);

// 	$list_ids = [16];
        $list_ids = [];

        if($division === 'Rookie'){
            array_push($list_ids, 18);
        } else if($division === 'Mites'){
            array_push($list_ids, 19);
        } else {
            array_push($list_ids, 17);
        }

        if($kid2_division){
            if($kid2_division === 'Rookie'){
                array_push($list_ids, 18);
            } else if($kid2_division === 'Mites'){
                array_push($list_ids, 19);
            } else {
                array_push($list_ids, 17);
            }
        }

        if($kid3_division){
            if($kid3_division === 'Rookie'){
                array_push($list_ids, 18);
            } else if($kid3_division === 'Mites'){
                array_push($list_ids, 19);
            } else {
                array_push($list_ids, 17);
            }
        }

        $list_ids = array_unique($list_ids);
        try {
            $get_subscriber = $mailpoet_api->getSubscriber($user_email);
        } catch (\Exception $e) {}

        try {
            if (!$get_subscriber) {
                // Subscriber doesn't exist let's create one
                $mailpoet_api->addSubscriber(['email' => $user_email, 'first_name' => $user_first, 'last_name' => $user_last], $list_ids);
            } else {
                // In case subscriber exists just add him to new lists
                $mailpoet_api->subscribeToLists($user_email, $list_ids);
                $mailpoet_api->updateSubscriber($user_email, ['first_name' => $user_first, 'last_name' => $user_last]);
            }
        } catch (\Exception $e) {
            $error_message = $e->getMessage();
        }

        $user_object = get_user_by('email', $user_email);

        $user_data = wp_update_user( array( 'ID' => $user_object->id, 'user_url' => '' ) );

    }
}

/**
 * Add the notices plugin page.
 */
function alderwood_core_roster_notices_page()
{
    add_submenu_page(
        'alderwood-roster',
        __('Notices', 'alderwood-core-plugin'),
        __('Notices', 'alderwood-core-plugin'),
        'manage_options',
        'alderwood-roster-notices',
        'alderwood_roster_notices'
    );
}

add_action('admin_menu', 'alderwood_core_roster_notices_page');

function alderwood_roster_notices () {
    $html = '';
    $notices_array = get_option('notices');
    $html.= "<div id='notices-wrapper'>";
    $html.= "<h2>Notices Banner Settings</h2>";
    $html.= "<form id='notices-form'";
    $html.= "<label>Text:</label><br><textarea name='notices-text' rows='8' cols='50'>". stripslashes($notices_array['text'])."</textarea>";
    $html.= "<label>Background-Color:</label><input type='color' name='notices-background-color' value='".$notices_array['background-color']."'>";
    $html.= "<label>Text-Color:</label><input type='color' name='notices-text-color' value='".$notices_array['text-color']."'>";
    $html.= "<label>Display Banner:</label><div id='notices-buttons'>";
    if($notices_array['hidden'] === 'Yes') {
        $html .= "<label>Yes</label><input type='radio' name='hidden' value='Yes' checked><label>No</label><input type='radio' name='hidden' value='No'>";
    } else {
        $html .= "<label>Yes</label><input type='radio' name='hidden' value='Yes'><label>No</label><input type='radio' name='hidden' value='No' checked>";
    }
    $html.= "</div><button type='button' id='update_notice' style='-webkit-appearance: none !important;'>Save</button>";
    $html.= "</form></div>";
    echo $html;
}

add_action("wp_ajax_update_notice", "update_notice");
function update_notice()
{
    $pairs = explode('&', $_POST['data']);
    $data = [];
    foreach ($pairs as $pair) {
        list($key, $value) = explode('=', $pair);
        $data[urldecode($key)] = urldecode($value);
    }

    update_option('notices', ['text' => $data['notices-text'], 'background-color' => $data['notices-background-color'], 'text-color' => $data['notices-text-color'], 'hidden' => $data['hidden']]);
    wp_send_json_success();
}

// Add HTML for notice-bar
add_action( 'wp_footer', function(){ ?>
	<script type="text/javascript">
	    jQuery('#close-notice').click(function () {
			jQuery(this).parent().parent().remove();
		});
	</script> <?php
});

// Add HTML for notice-bar
add_action( 'wp_head', function(){
    $notices_array = get_option('notices'); ?>
    <div id="notice-bar" style="<?php if($notices_array['hidden'] === 'Yes'){?>display: inherit;<?php } ?> background-color: <?= $notices_array['background-color'] ?>;"><div id="notice-container"><p style="color: <?= $notices_array['text-color'] ?>;"><?= stripslashes($notices_array['text']) ?></p><span id="close-notice">X</span></div></div>
<?php });