<?php
function alderwood_roster_coaches()
{
    $coaches = get_users(array('role__in' => array('coaches')));

    $teams = get_option('teams', []);

	$roster = [];
	foreach($teams as $key => $value) {
	    $team_name = $value[0];
		$roster[$team_name][] = [$key];
	}
    ?>
    <div class="datatables_modal hidden">
        <h2>Enter the coaches information below</h2>
        <form name="modal_coaches_form" id="modal_coaches_form">
            <label>First Name</label>
            <input type="text" name="first_name" required>
            <label>Last Name</label>
            <input type="text" name="last_name" required>
            <label>Email</label>
            <input type="email" name="email" required>
            <label>Phone Number</label>
            <input type="tel" name="phone" required>
            <label>Designation</label>
			<select name="coach_designation" required>
				<option value="primary">Primary</option>
				<option value="secondary">Secondary</option>		
			</select>
			<label>Team</label>
            <select name="team_dropdown" required><?php
	 			if (count($teams) > 0) {
					echo '<option disabled selected>Select a team</option>';
					foreach($roster as $division => $teams){
                        echo '<optgroup label="' . $division . '">';
						foreach($teams as $team){
							echo '<option value="' . $team[0] . '">' . $team[0] . '</option>';
						}
						echo '</optgroup>';
					}
                }
                 else {
                    echo '<option value="none">No teams!</option>';
                } ?>
            </select>
            <button type="button" id="add_coach">Add</button>
            <button type="button" id="cancel_coach">Close</button>
        </form>
    </div>
    <div class="datatables_header">
        <button type="button" id="coach_modal" class="datatable_header_button_add">Add Coach</button>
        <button type="button" id="delete_coach" class="datatable_header_button_delete">Delete</button>
    </div>
    <div class="datatables_wrapper">
        <?php
        if (count($coaches) > 0) { ?>
            <table id="coaches" class="display" style="width:100%">
                <thead>
                <tr>
                    <th>First Name</th>
                    <th>Last Name</th>
                    <th>Email</th>
                    <th>Phone Number</th>
                    <th>Team</th>
					<th>Designation</th>
                    <th>Created On</th>
                    <th>Actions</th>
                </tr>
                </thead>
                <tbody>
                <?php
                foreach ($coaches as $coach) {
                    $user = new WP_User($coach->ID);
					                   $team = $user->team;



					
                    $first_name = $user->first_name;
                    $last_name = $user->last_name;
                    $phone_number = $user->phone_number;
					
					$designation = $user->designation;
                    ?>
                    <tr>
                        <td><?= $first_name ?></td>
                        <td><?= $last_name ?></td>
                        <td><?= $coach->user_email ?></td>
                        <td><?= $phone_number ?></td>
                        <td><?= $team ?></td>
						<td><?= $designation ?></td>
                        <td><?= $coach->user_registered ?></td>
                        <td id="<?= $coach->ID ?>">
                            <input type="checkbox" name="delete_select" class="delete_select" value="delete">
                            <label>Delete</label>
                        </td>
                    </tr>
                    <?php
                } ?>
                </tbody>
                <tfoot>
                <tr>
                    <th>First Name</th>
                    <th>Last Name</th>
                    <th>Email</th>
                    <th>Phone Number</th>
                    <th>Team</th>
					<th>Designation</th>
                    <th>Created On</th>
                    <th>Actions</th>
                </tr>
                </tfoot>
            </table>
            <?php
        } else {
            echo '<p>No coaches have been added yet.</p>';
        }
        ?>
    </div>
    <?php
}

add_action("wp_ajax_create_coach", "create_coach");
function create_coach()
{
    $pairs = explode('&', $_POST['data']);
    $data = [];
    foreach ($pairs as $pair) {
        list($key, $value) = explode('=', $pair);
        $data[urldecode($key)] = urldecode($value);
    }
    $userdata = [
        'user_email' => $data['email'],
        'user_login' => $data['first_name'] . '_' . $data['last_name'],
        'first_name' => $data['first_name'],
        'last_name' => $data['last_name'],
        'role' => 'coaches',
    ];
    	$userid = wp_insert_user($userdata);
	  	$teams = get_option('teams');
		$active_list_id = $teams[$data['team_dropdown']][1];

    if (!is_wp_error($userid)) {
        add_user_meta($userid, 'phone_number', $data['phone']);
        add_user_meta($userid, 'team', $data['team_dropdown']);
		add_user_meta($userid, 'designation', $data['coach_designation']);
    } else {
        /* Error Handling */
//         var_dump($userid);
    }
	
	$list_ids = [13, $active_list_id];
	
	if (class_exists(\MailPoet\API\API::class)) {
  		// Get MailPoet API instance
		$mailpoet_api = \MailPoet\API\API::MP('v1');
		$mailpoet_api->subscribeToLists($data['email'], $list_ids);
	}
    wp_send_json_success();
}

add_action("wp_ajax_delete_coach", "delete_coach");
function delete_coach()
{
    foreach ($_POST['data'] as $coach) {
        wp_delete_user($coach);
    }
    wp_send_json_success();
}