jQuery(document).ready(function ($) {
	if($('.datatables_wrapper #coaches').length > 0){
    	new DataTable('#coaches');
	}
	
	if($('.datatables_wrapper #administration').length > 0){
    	new DataTable('#administration');
	}
	if($('.datatables_wrapper #umpires').length > 0){
    	new DataTable('#umpires');
	}
	if($('.datatables_wrapper #teams').length > 0){
    	new DataTable('#teams');
	}
	if($('.datatables_wrapper #divisions').length > 0){
    	new DataTable('#divisions');
	}
	if($('.datatables_wrapper #players').length > 0){
    	new DataTable('#players');
	}

    $('#coach_modal').click(function () {
        $('.datatables_modal').toggleClass('hidden');
    });

    $('#administration_modal').click(function () {
        $('.datatables_modal').toggleClass('hidden');
    })

    $('#umpire_modal').click(function () {
        $('.datatables_modal').toggleClass('hidden');
    })

    $('#team_modal').click(function () {
        $('.datatables_modal').toggleClass('hidden');
    })

    $('#division_modal').click(function () {
        $('.datatables_modal').toggleClass('hidden');
    })

    $('#player_modal').click(function () {
        $('.datatables_modal').toggleClass('hidden');
    })

    $('#cancel_coach').click(function () {
        $('.datatables_modal').addClass('hidden');
    })

    $('#cancel_administration').click(function () {
        $('.datatables_modal').addClass('hidden');
    })

    $('#cancel_umpire').click(function () {
        $('.datatables_modal').addClass('hidden');
    })

    $('#cancel_team').click(function () {
        $('.datatables_modal').addClass('hidden');
    })

    $('#cancel_division').click(function () {
        $('.datatables_modal').addClass('hidden');
    })

    $('#cancel_player').click(function () {
        $('.datatables_modal').addClass('hidden');
    })

    $('#add_coach').click(function () {
        var formData = $('#modal_coaches_form').serialize();
        $.ajax({
            type: 'POST',
            url: ajax_object.ajaxurl,
            data: {
                data: formData,
                action: 'create_coach',
            },
            success: function (response) {
                // On success
                location.reload();
            },
            error: function (jqXHR, textStatus, errorThrown) {
                // On error
            },
        });
    });

    $('#add_administration').click(function () {
        var formData = $('#modal_administration_form').serialize();
        $.ajax({
            type: 'POST',
            url: ajax_object.ajaxurl,
            data: {
                data: formData,
                action: 'create_administration',
            },
            success: function (response) {
                // On success
                location.reload();
            },
            error: function (jqXHR, textStatus, errorThrown) {
                // On error
            },
        });
    });

    $('#add_umpire').click(function () {
        var formData = $('#modal_umpires_form').serialize();
        $.ajax({
            type: 'POST',
            url: ajax_object.ajaxurl,
            data: {
                data: formData,
                action: 'create_umpire',
            },
            success: function (response) {
                // On success
                location.reload();
            },
            error: function (jqXHR, textStatus, errorThrown) {
                // On error
            },
        });
    });

    $('#add_team').click(function () {
        var formData = $('#modal_teams_form').serialize();
        $.ajax({
            type: 'POST',
            url: ajax_object.ajaxurl,
            data: {
                data: formData,
                action: 'create_team',
            },
            success: function (response) {
                // On success
                location.reload();
            },
            error: function (jqXHR, textStatus, errorThrown) {
                // On error
            },
        });
    });

    $('#add_division').click(function () {
        var formData = $('#modal_divisions_form').serialize();
        $.ajax({
            type: 'POST',
            url: ajax_object.ajaxurl,
            data: {
                data: formData,
                action: 'create_division',
            },
            success: function (response) {
                // On success
                location.reload();
            },
            error: function (jqXHR, textStatus, errorThrown) {
                // On error
            },
        });
    });
	
	$('#update_notice').click(function () {
        var formData = $('#notices-form').serialize();
        $.ajax({
            type: 'POST',
            url: ajax_object.ajaxurl,
            data: {
                data: formData,
                action: 'update_notice',
            },
            success: function (response) {
                // On success
                location.reload();
            },
            error: function (jqXHR, textStatus, errorThrown) {
                // On error
            },
        });
    });

    $('#assign_player').click(function () {
        var unassign_ids = [];
        $('.unassign_select').each(function () {
			$parent_id = $(this).parent().data('id');
            $checked = $(this).is(':checked');
            if ($checked) {
				if($(this).hasClass('child2')){
					unassign_ids.push([$parent_id, 2]);
				} else if($(this).hasClass('child1')){
					unassign_ids.push([$parent_id, 1]);
				} else {
					unassign_ids.push([$parent_id, 0]);
				}
			}
		});

        if (unassign_ids.length > 0) {
            var team = $('#team_dropdown option:selected').val();
            $.ajax({
                type: 'POST',
                url: ajax_object.ajaxurl,
                data: {
                    data: [unassign_ids, team],
                    action: 'assign_player',
                },
                success: function (response) {
                    // On success
                    location.reload();
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    // On error
                },
            });
        }
    });

    $('#unassign_player').click(function () {
        var unassign_ids = [];
        $('.unassign_select').each(function () {
			$parent_id = $(this).parent().data('id');
			$team = $(this).parent().data('team');
            $checked = $(this).is(':checked');
            if ($checked) {				
				if($(this).hasClass('child2')){
					unassign_ids.push([$parent_id, 2, $team]);
				} else if($(this).hasClass('child1')){
					unassign_ids.push([$parent_id, 1, $team]);
				} else {
					unassign_ids.push([$parent_id, 0, $team]);
				}
            }
        });
        if (unassign_ids.length > 0) {
            $.ajax({
                type: 'POST',
                url: ajax_object.ajaxurl,
                data: {
                    data: unassign_ids,
                    action: 'unassign_player',
                },
                success: function (response) {
                    // On success
                    location.reload();
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    // On error
                },
            });
        }
    });

    $('#delete_coach').click(function () {
        var delete_ids = [];
        $('.delete_select').each(function () {
            $checked = $(this).is(':checked');
            console.log($checked);
            if ($checked) {
                delete_ids.push($(this).parent().attr('id'));
            }
        });

        if (delete_ids.length > 0) {
            $.ajax({
                type: 'POST',
                url: ajax_object.ajaxurl,
                data: {
                    data: delete_ids,
                    action: 'delete_coach',
                },
                success: function (response) {
                    // On success
                    location.reload();
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    // On error
                },
            });
        }
    });

    $('#delete_administration').click(function () {
        var delete_ids = [];
        $('.delete_select').each(function () {
            $checked = $(this).is(':checked');
            if ($checked) {
                delete_ids.push($(this).parent().attr('id'));
            }
        });

        if (delete_ids.length > 0) {
            $.ajax({
                type: 'POST',
                url: ajax_object.ajaxurl,
                data: {
                    data: delete_ids,
                    action: 'delete_administration',
                },
                success: function (response) {
                    // On success
                    location.reload();
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    // On error
                },
            });
        }
    });

    $('#delete_umpire').click(function () {
        var delete_ids = [];
        $('.delete_select').each(function () {
            $checked = $(this).is(':checked');
            if ($checked) {
                delete_ids.push($(this).parent().attr('id'));
            }
        });

        if (delete_ids.length > 0) {
            $.ajax({
                type: 'POST',
                url: ajax_object.ajaxurl,
                data: {
                    data: delete_ids,
                    action: 'delete_umpire',
                },
                success: function (response) {
                    // On success
                    location.reload();
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    // On error
                },
            });
        }
    });

    $('#delete_team').click(function () {
        var delete_ids = [];
        $('.delete_select').each(function () {
            $checked = $(this).is(':checked');
            if ($checked) {
                delete_ids.push($(this).parent().attr('id'));
            }
        });

        if (delete_ids.length > 0) {
            $.ajax({
                type: 'POST',
                url: ajax_object.ajaxurl,
                data: {
                    data: delete_ids,
                    action: 'delete_team',
                },
                success: function (response) {
                    // On success
                    location.reload();
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    // On error
                },
            });
        }
    });

    $('#delete_division').click(function () {
        var delete_ids = [];
        $('.delete_select').each(function () {
            $checked = $(this).is(':checked');
            if ($checked) {
                delete_ids.push($(this).parent().attr('id'));
            }
        });

        if (delete_ids.length > 0) {
            $.ajax({
                type: 'POST',
                url: ajax_object.ajaxurl,
                data: {
                    data: delete_ids,
                    action: 'delete_division',
                },
                success: function (response) {
                    // On success
                    location.reload();
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    // On error
                },
            });
        }
    });
	
    $('#delete_player').click(function () {
        var delete_ids = [];
        $('.delete_select').each(function () {
            $checked = $(this).is(':checked');
            if ($checked) {
                delete_ids.push($(this).parent().attr('id'));
            }
        });

        if (delete_ids.length > 0) {
            $.ajax({
                type: 'POST',
                url: ajax_object.ajaxurl,
                data: {
                    data: delete_ids,
                    action: 'delete_player',
                },
                success: function (response) {
                    // On success
                    location.reload();
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    // On error
                },
            });
        }
    });
});