<?php
function alderwood_roster_divisions()
{
    $divisions = get_option('divisions', []);
    ?>
    <div class="datatables_modal hidden">
        <h2>Enter the divisions information below</h2>
        <form name="modal_divisions_form" id="modal_divisions_form">
            <label>Name</label>
            <input type="text" name="name" required>
            <button type="button" id="add_division">Add</button>
            <button type="button" id="cancel_division">Close</button>
        </form>
    </div>
    <div class="datatables_header">
        <button type="button" id="division_modal" class="datatable_header_button_add">Add Division</button>
        <button type="button" id="delete_division" class="datatable_header_button_delete">Delete</button>
    </div>
    <div class="datatables_wrapper">
        <?php
        if (count($divisions) > 0) { ?>
            <table id="divisions" class="display" style="width:100%">
                <thead>
                <tr>
                    <th>Name</th>
                    <th>Actions</th>
                </tr>
                </thead>
                <tbody>
                <?php
                foreach ($divisions as $division) { ?>
                    <tr>
                        <td><?= $division ?></td>
                        <td id="<?= $division ?>">
                            <input type="checkbox" name="delete_select" class="delete_select" value="delete">
                            <label>Delete</label>
                        </td>
                    </tr>
                    <?php
                } ?>
                </tbody>
                <tfoot>
                <tr>
                    <th>Name</th>
                    <th>Actions</th>
                </tr>
                </tfoot>
            </table>
            <?php
        } else {
            echo '<p>No divisions have been added yet.</p>';
        }
        ?>
    </div>
    <?php
}

add_action("wp_ajax_create_division", "create_division");
function create_division()
{
    $pairs = explode('&', $_POST['data']);
    $data = [];
    foreach ($pairs as $pair) {
        list($key, $value) = explode('=', $pair);
        $data[urldecode($key)] = urldecode($value);
    }

    $values = get_option('divisions');
    if (is_array($values)) {
        array_push($values, $data['name']);
    } else {
        $values = [$data['name']];
    }
    update_option('divisions', $values);
    wp_send_json_success();
}

add_action("wp_ajax_delete_division", "delete_division");
function delete_division()
{
    foreach ($_POST['data'] as $division) {
        wp_delete_user($division);
        $values = get_option('divisions');
        if (is_array($values)) {
            $delete_divisions = array_diff($values, [$division]);
            update_option('divisions', $delete_divisions);
        }
    }
    wp_send_json_success();
}