<?php
function alderwood_roster_players()
{
    $players = get_users(array('role__in' => array('asa-kids')));
    $teams = get_option('teams', []);	
    ?>
    <div class="datatables_modal hidden">
        <h2>Select the player(s) team below</h2>
        <form name="modal_player_form" id="modal_player_form">
            <label>Team</label>
            <select name="team_dropdown" id="team_dropdown" required><?php
                if (count($teams) > 0) {
                    foreach ($teams as $key => $value) {
                        echo '<option value="' . $key . '">' . $key . '</option>';
                    }
                } else {
                    echo '<option value="none">No teams!</option>';
                } ?>
            </select>

            <button type="button" id="assign_player">Add</button>
            <button type="button" id="cancel_player">Close</button>
        </form>
    </div>
    <div class="datatables_header">
        <button type="button" id="player_modal" class="datatable_header_button_assign">Assign</button>
        <button type="button" id="unassign_player" class="datatable_header_button_unassign">Unassign</button>
<!--        <button type="button" id="delete_player" class="datatable_header_button_delete">Delete</button>-->
    </div>
    <div class="datatables_wrapper">
        <?php
        if (count($players) > 0) { ?>
            <table id="players" class="display" style="width:100%">
                <thead>
                <tr>
                    <th>First Name</th>
                    <th>Last Name</th>
                    <th>Email</th>
                    <th>Phone Number</th>
                    <th>Division</th>
                    <th>Team</th>
                    <th>Registered On</th>
                    <th>Actions</th>
                </tr>
                </thead>
                <tbody>
                <?php
                foreach ($players as $player) {
                        $user = new WP_User($player->ID);
						$meta = get_user_meta($player->ID);
                        $first_name = $user->first_name;
                        $last_name = $user->last_name;
                        $phone_number = $meta['user_registration_input_box_1736139766'][0];
                        $team = $user->team;
					
								


// if($team === "M3 - Porrit Real Estate"){
// $team = "M3 - Porritt Real Estate";
// }

// 			$user_data = update_user_meta( $player->ID, 'team', $team);
					
					
                        $division = $meta['user_registration_multiple_choice_1737232628'][0];
						$division = explode(" ",$division);
						$division = str_replace('["','',$division[0]);
					
                        ?>
                        <tr>
                            <td><?= $first_name ?></td>
                            <td><?= $last_name ?></td>
                            <td><?= $player->user_email ?></td>
                            <td><?= $phone_number ?></td>
                            <td><?= $division ?></td>
                            <td><?= $team ?></td>
                            <td><?= $player->user_registered ?></td>
                            <td data-id="<?= $player->ID ?>" data-team="<?= $team ?>">
<!--                                <input type="checkbox" name="delete_select" class="delete_select" value="delete">-->
<!--                                <label>Delete</label>-->
                                <input type="checkbox" name="unassign_select" class="unassign_select" value="unassign">
                                <label>Unassign/Assign</label>
                            </td>
                        </tr>
                        <?php
						if($meta['user_registration_input_box_1737223180'][0]){ 
							$division2 = $meta['user_registration_multiple_choice_1737232683757'][0];
							$division2 = explode(" ",$division2);
							$division2 = str_replace('["','',$division2[0]);
							$team2 = $meta['team2'][0];
							
// if($team2 === "M3 - Porrit Real Estate"){
// $team2 = "M3 - Porritt Real Estate";
// }

// 			$user_data = update_user_meta( $player->ID, 'team2', $team2 );
					

							?>
							 <tr>
                            <td><?= $meta['user_registration_input_box_1737223180'][0] ?></td>
                            <td><?= $meta['user_registration_input_box_1737223196'][0] ?></td>
                            <td><?= $player->user_email ?></td>
                            <td><?= $phone_number ?></td>
                            <td><?= $division2 ?></td>
                            <td><?= $team2 ?></td>
                            <td><?= $player->user_registered ?></td>
                            <td data-id="<?= $player->ID ?>">
                                <input type="checkbox" name="delete_select" class="delete_select" value="delete">
                                <label>Delete</label>
                                <input type="checkbox" name="unassign_select" class="unassign_select child1" value="unassign">
                                <label>Unassign/Assign</label>
                            </td>
                        </tr>
					<?php
						}
						
						if($meta['user_registration_input_box_1737223356989'][0]){ 
							$division3 = $meta['user_registration_multiple_choice_1737232683344'][0];
							$division3 = explode(" ",$division3);
							$division3 = str_replace('["','',$division3[0]);
							$team3 = $meta['team3'][0];
							
							// if($team2 === "M3 - Porrit Real Estate"){
// $team2 = "M3 - Porritt Real Estate";
// }

// 			$user_data = wp_update_user( array( 'ID' => $player->ID, 'team2' => $team2 ) );
							
						?>
						 <tr>
                            <td><?= $meta['user_registration_input_box_1737223356989'][0] ?></td>
                            <td><?= $meta['user_registration_input_box_1737223377860'][0] ?></td>
                            <td><?= $player->user_email ?></td>
                            <td><?= $phone_number ?></td>
                            <td><?= $division3 ?></td>
                            <td><?= $team3 ?></td>
                            <td><?= $player->user_registered ?></td>
                            <td data-id="<?= $player->ID ?>">
                                <input type="checkbox" name="delete_select" class="delete_select" value="delete">
                                <label>Delete</label>
                                <input type="checkbox" name="unassign_select" class="unassign_select child2" value="unassign">
                                <label>Unassign/Assign</label>
                            </td>
                        </tr>
					<?php
						}
                }
                ?>
                </tbody>
                <tfoot>
                <tr>
                    <th>First Name</th>
                    <th>Last Name</th>
                    <th>Email</th>
                    <th>Phone Number</th>
                    <th>Division</th>
                    <th>Team</th>
                    <th>Registered On</th>
                    <th>Actions</th>
                </tr>
                </tfoot>
            </table>
            <?php
        } else {
            echo '<p>No players have registered yet.</p>';
        }
        ?>
    </div>

    <?php

}

add_action("wp_ajax_assign_player", "assign_player");
function assign_player()
{
	foreach ($_POST['data'][0] as $user_id) {
        $user = new WP_User($user_id[0]);

		if($user_id[1] == 1){
			update_user_meta($user->ID, 'team2', $_POST['data'][1]);
		} else if($user_id[1] == 2){
        	update_user_meta($user->ID, 'team3', $_POST['data'][1]);
		} else {
			update_user_meta($user->ID, 'team', $_POST['data'][1]);
		}

        $teams = get_option('teams', []);
        $team_name = $_POST['data'][1];
        if (class_exists(\MailPoet\API\API::class)) {
            // Get MailPoet API instance
            $mailpoet_api = \MailPoet\API\API::MP('v1');
            $mailpoet_api->subscribeToList($user->user_email, $teams[$team_name][1]);
        }
    }
    wp_send_json_success();
}

add_action("wp_ajax_unassign_player", "unassign_player");
function unassign_player()
{
	foreach ($_POST['data'] as $user_id) {
        $user = new WP_User($user_id[0]);

		if($user_id[1] == 1){
			delete_user_meta($user->ID, 'team2');
		} else if($user_id[1] == 2){
        	delete_user_meta($user->ID, 'team3');
		} else {
			delete_user_meta($user->ID, 'team');
		}

        $teams = get_option('teams', []);
        $team_name = $_POST['data'][0][2];
        if (class_exists(\MailPoet\API\API::class)) {
            // Get MailPoet API instance
            $mailpoet_api = \MailPoet\API\API::MP('v1');
            $mailpoet_api->unsubscribeFromList($user->user_email, $teams[$team_name][1]);
        }
    }
    wp_send_json_success();
}


// add_action("wp_ajax_delete_player", "delete_player");
function delete_player()
{
    foreach ($_POST['data'] as $player) {
        wp_delete_user($player);
    }
    wp_send_json_success();
}