<?php
// shortcode to display each division and their team
add_shortcode( 'teams_view', 'teams_view_func' );
function teams_view_func( $atts ) {
    $roster = [];
    $teams = get_option('teams');
    $coaches = get_users(array('role__in' => array('coaches')));
    $players = get_users(array('role__in' => array('asa-kids')));

    foreach($players as $player){
        if ($player->ID !== 1) {
            $user = new WP_User($player->ID);
            $team = $user->team;
			

            $meta = get_user_meta($player->ID);
            $first_name = $user->first_name;
            $last_name = $user->last_name;
            $player_division = $meta['user_registration_multiple_choice_1737232628'][0];
            $player_division = explode(" ",$player_division);
            $player_division = str_replace('["','',$player_division[0]);

            array_push($roster, ['first_name' => $first_name, 'last_name' => $last_name, 'division' => $player_division, 'team' => $team]);

            if($meta['user_registration_input_box_1737223180'][0]){
                $division2 = $meta['user_registration_multiple_choice_1737232683757'][0];
                $division2 = explode(" ",$division2);
                $division2 = str_replace('["','',$division2[0]);
                $team2 = $meta['team2'][0];

                array_push($roster, ['first_name' =>  $meta['user_registration_input_box_1737223180'][0], 'last_name' => $meta['user_registration_input_box_1737223196'][0], 'division' => $division2, 'team' => $team2]);
            }

            if($meta['user_registration_input_box_1737223356989'][0]){
                $division3 = $meta['user_registration_multiple_choice_1737232683344'][0];
                $division3 = explode(" ",$division3);
                $division3 = str_replace('["','',$division3[0]);
                $team3 = $meta['team3'][0];

                array_push($roster, ['first_name' =>  $meta['user_registration_input_box_1737223356989'][0], 'last_name' => $meta['user_registration_input_box_1737223377860'][0], 'division' => $division3, 'team' => $team3]);
            }
        }
    }


    $divisions = get_option('divisions', []);
    echo "<div id='teams-view-container'><select name='division_dropdown' class='division_dropdown'required>";
    if (count($divisions) > 0) {
        foreach ($divisions as $division) {
            echo '<option value="' . $division . '">' . $division . '</option>';
        }
    } else {
        echo '<option value="none">No Divisions!</option>';
    }
    echo "</select>";
    foreach($divisions as $division) {
        $html.= "<div class='team-view-division hidden ".strtolower($division)."'><h4>".$division."</h4><div class='team-container'>";
        if (count($teams) > 0) {
            foreach($teams as $key => $value) {
                $team_key = $key;
                if(strtolower($value[0]) === strtolower($division)){
                    $html.= "<div class='individual-team'><p class='team-view-team'>".$key."</p><div class='hidden'><div class='team-coaches'><p style='font-weight: bold; font-size: 18px;'>Coaches:</p>";
                    foreach ($coaches as $coach) {
                        $user = new WP_User($coach->ID);
                        $first_name = $user->first_name;
                        $last_name = $user->last_name;
                        $team = $user->team;
						$designation = $user->designation;
                        if(strtolower($team) === strtolower($key)){
                            $html.= "<div class='$designation'><span>$first_name" . ' ' .  "$last_name</span></div> ";
                        }
                    }
                    $html.="</div>";
                    $html.="<ul>";

                    foreach($roster as $player){
                        if(strtolower($player['division']) === strtolower($division) && strtolower($player['team']) === strtolower($team_key)){
                            $html.= '<li class="team-player">'.$player['first_name'] . ' ' . $player['last_name'].'</li>';
                        }
                    }

                    $html.="</ul>";
                    $html.="</div></div>";
                }
            }
        }
        $html.= "</div></div>";
    }
    $html.= "</div>";
    return $html;
}