<?php
function alderwood_roster_teams()
{
    $teams = get_option('teams', []);
	
	$divisions = get_option('divisions', []);
    ?>
    <div class="datatables_modal hidden">
        <h2>Enter the teams information below</h2>
        <form name="modal_teams_form" id="modal_teams_form">
            <label>Name</label>
            <input type="text" name="name" required>
			<label>Division</label>
            <select name="division_dropdown" required><?php
                if (count($divisions) > 0) {
                    foreach ($divisions as $division) {
                        echo '<option value="' . $division . '">' . $division . '</option>';
                    }
                } else {
                    echo '<option value="none">No Divisions!</option>';
                } ?>
            </select>
            <button type="button" id="add_team">Add</button>
            <button type="button" id="cancel_team">Close</button>
        </form>
    </div>
    <div class="datatables_header">
        <button type="button" id="team_modal" class="datatable_header_button_add">Add Team</button>
        <button type="button" id="delete_team" class="datatable_header_button_delete">Delete</button>
    </div>
    <div class="datatables_wrapper">
        <?php
        if (count($teams) > 0) { ?>
            <table id="teams" class="display" style="width:100%">
                <thead>
                <tr>
                    <th>Name</th>
					<th>Division</th>
                    <th>Actions</th>
                </tr>
                </thead>
                <tbody>
                <?php
                foreach ($teams as $key => $value) { ?>
                    <tr>
                        <td><?= $key ?></td>
						<td><?= $value[0] ?></td>
                        <td id="<?= $key ?>">
                            <input type="checkbox" name="delete_select" class="delete_select" value="delete">
                            <label>Delete</label>
                        </td>
                    </tr>
                    <?php
                } ?>
                </tbody>
                <tfoot>
                <tr>
                    <th>Name</th>
					<th>Division</th>
                    <th>Actions</th>
                </tr>
                </tfoot>
            </table>
            <?php
        } else {
            echo '<p>No teams have been added yet.</p>';
        }
        ?>
    </div>
    <?php
}

add_action("wp_ajax_create_team", "create_team");
function create_team()
{
    $pairs = explode('&', $_POST['data']);
    $data = [];
    foreach ($pairs as $pair) {
        list($key, $value) = explode('=', $pair);
        $data[urldecode($key)] = urldecode($value);
    }

    $name = $data['name'];
	
	$mailpoetID = null;
	if (class_exists(\MailPoet\API\API::class)) {
  		// Get MailPoet API instance
		$mailpoet_api = \MailPoet\API\API::MP('v1');
		$mailpoetID = $mailpoet_api->addList(['name' =>$name]);
	}
    $division = $data['division_dropdown'];
    $values = get_option('teams');
    $values[$name] = [$division,$mailpoetID['id']];
    update_option('teams', $values);
	wp_send_json_success();
}

add_action("wp_ajax_delete_team", "delete_team");
function delete_team()
{
    foreach ($_POST['data'] as $team) {
//         wp_delete_user($team);
        $values = get_option('teams');
		$list_id = $values[$team][1];

        unset($values[$team]);
        update_option('teams', $values);
		
		if (class_exists(\MailPoet\API\API::class)) {
			// Get MailPoet API instance
			$mailpoet_api = \MailPoet\API\API::MP('v1');
			$mailpoet_api->deleteList($list_id);
		}
    }
    wp_send_json_success();
}