<?php
function alderwood_roster_umpires()
{
    $umpires = get_users(array('role__in' => array('umpires')));
    ?>
    <div class="datatables_modal hidden">
        <h2>Enter the umpires information below</h2>
        <form name="modal_umpires_form" id="modal_umpires_form">
            <label>First Name</label>
            <input type="text" name="first_name" required>
            <label>Last Name</label>
            <input type="text" name="last_name" required>
            <label>Email</label>
            <input type="email" name="email" required>
            <label>Phone Number</label>
            <input type="tel" name="phone" required>
            <button type="button" id="add_umpire">Add</button>
            <button type="button" id="cancel_umpire">Close</button>
        </form>
    </div>
    <div class="datatables_header">
        <button type="button" id="umpire_modal" class="datatable_header_button_add">Add Umpire</button>
        <button type="button" id="delete_umpire" class="datatable_header_button_delete">Delete</button>
    </div>
    <div class="datatables_wrapper">
        <?php
        if (count($umpires) > 0) { ?>
            <table id="umpires" class="display" style="width:100%">
                <thead>
                <tr>
                    <th>First Name</th>
                    <th>Last Name</th>
                    <th>Email</th>
                    <th>Phone Number</th>
                    <th>Created On</th>
                    <th>Actions</th>
                </tr>
                </thead>
                <tbody>
                <?php
                foreach ($umpires as $umpire) {
                    $user = new WP_User($umpire->ID);
                    $first_name = $user->first_name;
                    $last_name = $user->last_name;
                    $phone_number = $user->phone_number;
                    $team = $user->team;
                    ?>
                    <tr>
                        <td><?= $first_name ?></td>
                        <td><?= $last_name ?></td>
                        <td><?= $umpire->user_email ?></td>
                        <td><?= $phone_number ?></td>
                        <td><?= $umpire->user_registered ?></td>
                        <td id="<?= $umpire->ID ?>">
                            <input type="checkbox" name="delete_select" class="delete_select" value="delete">
                            <label>Delete</label>
                        </td>
                    </tr>
                    <?php
                } ?>
                </tbody>
                <tfoot>
                <tr>
                    <th>First Name</th>
                    <th>Last Name</th>
                    <th>Email</th>
                    <th>Phone Number</th>
                    <th>Created On</th>
                    <th>Actions</th>
                </tr>
                </tfoot>
            </table>
            <?php
        } else {
            echo '<p>No umpires have been added yet.</p>';
        }
        ?>
    </div>
    <?php
}

add_action("wp_ajax_create_umpire", "create_umpire");
function create_umpire()
{
    $pairs = explode('&', $_POST['data']);
    $data = [];
    foreach ($pairs as $pair) {
        list($key, $value) = explode('=', $pair);
        $data[urldecode($key)] = urldecode($value);
    }
    $userdata = [
        'user_email' => $data['email'],
        'user_login' => $data['first_name'] . '_' . $data['last_name'],
        'first_name' => $data['first_name'],
        'last_name' => $data['last_name'],
        'role' => 'umpires',
    ];
    $userid = wp_insert_user($userdata);
    if (!is_wp_error($userid)) {
        add_user_meta($userid, 'phone_number', $data['phone']);
    } else {
        /* Error Handling */
        var_dump($userid);
    }
    wp_send_json_success();
}

add_action("wp_ajax_delete_umpire", "delete_umpire");
function delete_umpire()
{
    foreach ($_POST['data'] as $umpire) {
        wp_delete_user($umpire);
    }
    wp_send_json_success();
}