document.addEventListener("em_uploader_ready",function(e){let script=document.getElementById("filepond-js");if(script&&script.dataset.locale){let module="../external/filepond/locale/"+script.dataset.locale+".js";import(module).then(lang=>{if(lang.default){FilePond.setOptions(lang.default)}}).catch(e=>{console.log("Error loading locale : %o",e)})}let setup_em_loader;let getHiddenInputName=function(input,fileId,postFix){let name;if(input.dataset.fieldId&&input.name.includes(`[${input.dataset.fieldId}]`)){name=input.name.replace(`[${input.dataset.fieldId}]`,`[${input.dataset.fieldId}--${postFix}][${fileId}]`)}else{name=input.name.replace(/^([^[]+)(\[[\s\S]*)?$/,`$1--${postFix}$2`)+`[${fileId}]`}return name.replace(/\[\]/,"")};let filenames={};let sources={};setup_em_loader=function(container){container.querySelectorAll("input.em-uploader").forEach(input=>{let input_data={};let wrapper=input.closest(".em-input-upload")??input.parentElement;let pond;if(script){FilePond.registerPlugin(FilePondPluginFileValidateType,FilePondPluginFileValidateSize,FilePondPluginImageExifOrientation,FilePondPluginImageValidateSize,FilePondPluginGetFile,FilePondPluginImageOverlay,FilePondPluginImageThumbnail,FilePondPluginPdfPreviewOverlay,FilePondPluginFileIcon);const apiURL=new URL(EM.uploads.endpoint);apiURL.searchParams.set("path",input.dataset.apiPath||"");apiURL.searchParams.set("path_id",input.dataset.apiPathId||null);apiURL.searchParams.set("field_id",input.dataset.fieldId||"");let apiNonce=input.dataset.apiNonce?input.dataset.apiNonce:null;let filesOptions=wrapper.querySelector(".em-uploader-files");let files=[];if(filesOptions){let files_data=JSON.parse(filesOptions.text);if(files_data.length>0){files_data.forEach(file=>{let opt;if("url"in file){opt={source:file.url,type:"local",options:{metadata:{id:file.id,previouslyUploaded:true}}};if(!file.deleted){opt.options.type="local"}}else{opt={source:file.id,options:{type:"limbo",metadata:{id:file.id}}}}if("name"in file){opt.options.metadata.filename=file.name}file.opt=opt;input_data[file.id]=file;if(!file.deleted){files.push(opt)}})}}let pondOptions={files:files,allowMultiple:input.multiple,credits:false,server:{process:{url:apiURL.toString(),credentials:"same-origin",method:"POST",headers:{"X-WP-Nonce":EM.api_nonce,"X-EM-Nonce":apiNonce},onload:response=>{const data=JSON.parse(response);if(data.success&&data.file&&data.file.id){input_data[data.file.id]={name:data.file.name,size:data.file.size,type:data.file.type,nonce:data.nonce};const hiddenInput=document.createElement("input");hiddenInput.type="hidden";hiddenInput.name=getHiddenInputName(input,data.file.id,"names");hiddenInput.value=data.file.name;hiddenInput.className=input.name.replace(/\[.*$/,"")+"-"+data.file.id;wrapper.appendChild(hiddenInput)}wrapper.closest("form").onsubmit=null;return data.file.id},onerror:response=>response,withCredentials:true},revert:(uniqueFileId,load,error)=>{if(uniqueFileId in input_data){const url=new URL(apiURL.href);url.searchParams.set("tmp_file",uniqueFileId);url.searchParams.set("nonce",input_data[uniqueFileId].nonce);fetch(url,{method:"DELETE",credentials:"same-origin",headers:{"X-WP-Nonce":EM.api_nonce,"X-EM-Nonce":apiNonce}}).then(response=>{if(response.ok){return response.blob()}throw new Error("Failed to fetch file by ID.")}).then(load).catch(err=>{console.error(err);error(err.message)})}},load:(source,load,error)=>{let err=err=>{console.log(err);error(err.message)};if(source.startsWith("http://")||source.startsWith("https://")){let loadBlob=blob=>{if(filenames[source]){blob.name=filenames[source]}return load(blob)};if(sources[source]){sources[source].then(loadBlob).catch(err);return}sources[source]=fetch(source).then(response=>{if(response.ok){const disposition=response.headers.get("Content-Disposition");if(disposition&&disposition.indexOf("filename=")!==-1){const filenameRegex=/filename[^;=\n]*=((['"]).*?\2|[^;\n]*)/;const matches=filenameRegex.exec(disposition);if(matches!==null&&matches[1]){filenames[source]=matches[1].replace(/['"]/g,"")}}return response.blob()}throw new Error("Failed to fetch file from URL.")});sources[source].then(loadBlob).catch(err)}else if(source in input_data){let url=new URL(apiUrl);url.searchParams.set("file_id",source);url.searchParams.set("nonce",input_data[source].nonce);fetch(url,{method:"GET",credentials:"same-origin",headers:{"X-WP-Nonce":EM.api_nonce,"X-EM-Nonce":apiNonce}}).then(response=>{if(response.ok){return response.blob()}throw new Error("Failed to fetch file by ID.")}).then(load).catch(err)}},remove:null,restore:{url:apiURL.toString()+"&temp_id=",credentials:"same-origin",headers:{"X-WP-Nonce":EM.api_nonce,"X-EM-Nonce":apiNonce,"X-Filenames":JSON.stringify(input_data)}},fetch:null},beforeRemoveFile:item=>{let metaData=item.getMetadata();if("previouslyUploaded"in metaData&&metaData.previouslyUploaded){moveToTBD(metaData.id)}else{if(typeof item.serverId==="string"){wrapper.querySelectorAll("input."+input.name.replace(/\[.*$/,"")+"-"+item.serverId).forEach(input=>input.remove())}}return true},name:"filepond",allowDownloadByUrl:true,allowImageThumbnail:true,imagePreviewHeight:100,allowImageValidateSize:true,imageValidateSizeMinWidth:EM.uploads.images.image_min_width||0,imageValidateSizeMaxWidth:EM.uploads.images.image_max_width||6144,imageValidateSizeMinHeight:EM.uploads.images.image_min_height||0,imageValidateSizeMaxHeight:EM.uploads.images.image_max_height||6144,allowFileSizeValidation:true,maxFileSize:EM.uploads.files.max_file_size||null,allowFileTypeValidation:true,acceptedFileTypes:EM.uploads.files.types,allowFileIcon:true,fileIconIncludeImages:false,labelFileProcessingError:error=>{try{let errorData=JSON.parse(error.body);return errorData.error||"Upload failed."}catch(e){if(error.body){return error.body}}return"Error during upload"}};let inline_options=wrapper.querySelector(".em-uploader-options");if(inline_options){Object.assign(pondOptions,JSON.parse(inline_options.text))}if(typeof pondOptions.acceptedFileTypes==="undefined"||pondOptions.acceptedFileTypes.length===0){pondOptions.allowFileTypeValidation=false}pond=FilePond.create(input,pondOptions);let form=wrapper.closest("form");let offForm=e=>{if(e.origin===1){form.onsubmit=e=>false;form.disabled=true;form.querySelectorAll('input[type="submit"],button[type="submit"]').forEach(el=>{el.disabled=true})}else if(e.origin===3){const file=files.find(file=>file.options.type==="local"&&file.source===e.serverId);if(file){file.id=e.id;const li=wrapper.querySelector(`li.filepond--item#filepond--item-${e.id}`);if(li){const info=li.querySelector(".filepond--file-info-main");if(info.firstChild&&info.firstChild.nodeType===Node.TEXT_NODE){info.firstChild.nodeValue=file.options.metadata.filename}else{info.textContent=file.options.metadata.filename}}}}};pond.on("initfile",offForm);pond.on("processfilestart",offForm);let onForm=(error=null,file=null)=>{form.onsubmit=null;form.disabled=false;form.querySelectorAll('input[type="submit"],button[type="submit"]').forEach(el=>{el.disabled=false});if(error&&file){file.setMetadata("serverId",null)}};pond.on("processfiles",onForm);pond.on("processfile",onForm);pond.on("addfile",(error,file)=>{if(error){file.setMetadata("id",null);file.setMetadata("serverId",null)}});wrapper.querySelectorAll(".em-input-upload-fallback").forEach(el=>{el.classList.add("hidden")})}const tbdList=wrapper.querySelector(".em-input-upload-files-tbd");const uploadList=wrapper.querySelector(".em-input-upload-files");const updateListVisibility=()=>{if(tbdList){const tbdHasFiles=tbdList.querySelectorAll("li[data-file_id]").length>0;tbdList.classList.toggle("hidden",!tbdHasFiles)}if(uploadList){const uploadedHasFiles=uploadList.querySelectorAll("li[data-file_id]").length>0;uploadList.classList.toggle("hidden",!uploadedHasFiles)}};const checkUploadMaximums=()=>{if(!script){}};const getHiddenDeleteInput=fileId=>wrapper.querySelector(`input[type="hidden"][data-file_id="${fileId}"]`);const addDeleteInput=fileId=>{if(getHiddenDeleteInput(fileId))return;const hiddenInput=document.createElement("input");hiddenInput.type="hidden";hiddenInput.name=getHiddenInputName(input,fileId,"deleted");hiddenInput.value="1";hiddenInput.dataset.file_id=fileId;wrapper.appendChild(hiddenInput)};const removeDeleteInput=fileId=>{const existingInput=getHiddenDeleteInput(fileId);if(existingInput)existingInput.remove()};const moveToTBD=fileOrId=>{let fileItem;if(typeof fileOrId==="string"){fileItem=wrapper.querySelector(`.em-input-upload-files li[data-file_id="${fileOrId}"]`)}else{fileItem=fileOrId}if(fileItem){if(tbdList){tbdList.appendChild(fileItem)}const fileId=fileItem.dataset.file_id;addDeleteInput(fileId);updateListVisibility();updateInputVisibility()}};const moveToUploads=fileOrId=>{let fileItem;if(typeof fileOrId==="string"){fileItem=wrapper.querySelector(`.em-input-upload-files-tbd li[data-file_id="${fileOrId}"]`)}else{fileItem=fileOrId}if(fileItem){const fileId=fileItem.dataset.file_id;const maxFiles=parseInt(input.dataset.maxFiles,10)||(input.multiple?null:1);if(maxFiles){const uploadedCount=getUploadedFilesCount();const pendingCount=getPendingUploadCount();const totalFiles=uploadedCount+pendingCount+1;if(totalFiles>maxFiles){alert(`You cannot restore this file as it would exceed the maximum limit of ${maxFiles} files.`);return}}if(script&&pond&&input_data[fileId]){let file=input_data[fileId];file.opt.options.type="local";pond.addFile(file.opt.source,file.opt.options).then(()=>{if(uploadList){uploadList.appendChild(fileItem)}removeDeleteInput(fileId);updateListVisibility();updateInputVisibility()}).catch(()=>{alert(`Failed to restore file: ${input_data[fileId].name}`)})}else{removeDeleteInput(fileId);updateListVisibility();updateInputVisibility();if(uploadList){uploadList.appendChild(fileItem)}}}};wrapper.addEventListener("click",e=>{if(e.target.matches(".em-icon-trash")){const fileItem=e.target.closest("li[data-file_id]");moveToTBD(fileItem)}if(e.target.matches(".em-icon-undo")){const fileItem=e.target.closest("li[data-file_id]");moveToUploads(fileItem)}});updateListVisibility();const getUploadedFilesCount=()=>uploadList?uploadList.querySelectorAll("li[data-file_id]").length:0;const getPendingUploadCount=()=>input.files.length;const updateInputVisibility=()=>{const maxFiles=parseInt(input.dataset.maxFiles,10)||(input.multiple?null:1);if(!maxFiles)return;const uploadedCount=getUploadedFilesCount();const pendingCount=getPendingUploadCount();const totalFiles=uploadedCount+pendingCount;if(totalFiles>=maxFiles&&pendingCount===0){input.classList.add("hidden")}else{input.classList.remove("hidden")}};let lastValidFileSelection;const validateMaxFilesBeforeUpload=e=>{if(script)return;const maxFiles=parseInt(input.dataset.maxFiles,10)||(input.multiple?null:1);if(!maxFiles)return;const uploadedCount=getUploadedFilesCount();const selectedFilesCount=e.target.files.length;const totalFiles=uploadedCount+selectedFilesCount;if(totalFiles>maxFiles){alert(`You can only upload a maximum of ${maxFiles} files.`);if(lastValidFileSelection){input.files=lastValidFileSelection.files}else{input.value=""}}else{lastValidFileSelection=new DataTransfer;for(const file of input.files){lastValidFileSelection.items.add(file)}}updateInputVisibility()};updateInputVisibility();input.addEventListener("change",validateMaxFilesBeforeUpload)})};setup_em_loader(document);document.addEventListener("em_setup_ui_elements",e=>{setup_em_loader(e.detail.container)})});